#include "tbb/task_scheduler_init.h"
#include "tbb/parallel_sort.h"
#include "tbb/tick_count.h"
#include <cstdlib>
#include <iostream>

using namespace std;
using namespace tbb;

#define N 500000

int main(int argc, char* argv[])
{
	double *tablica1 = new double[N],
		   *tablica2 = new double[N];
	task_scheduler_init init;
	tick_count t0, t1, t2;
	
	for (int i = 0; i < N; ++i)
		tablica1[i] = tablica2[i] = (double)rand() / (double)RAND_MAX;
			
	t0 = tick_count::now();
	sort(tablica1, tablica1 + N, greater<double>());
	t1 = tick_count::now();
	parallel_sort(tablica2, tablica2 + N, greater<double>());
	t2 = tick_count::now();

	cout << "Wersja szeregowa:  " << (t1 - t0).seconds() << " s" << endl;
	cout << "Wersja rownolegla: " << (t2 - t1).seconds() << " s" << endl;
	delete[] tablica1, tablica2;

	cin.get();
	return 0;
}

